<?php
session_start();

if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: login.php');
    exit;
}

if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    // Baca sandi dari file
    $password_file = 'data/page_password.txt';
    if (!file_exists($password_file)) file_put_contents($password_file, '999');
    $correct_password = trim(file_get_contents($password_file));
    
    if ($_POST['password'] === $correct_password) {
        $_SESSION['logged_in'] = true;
        echo json_encode(['success' => true]);
        exit;
    } else {
        echo json_encode(['success' => false]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Suranto Galaxy</title>
    <link rel="icon" type="image/png" sizes="32x32" href="favicon-32.png">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Inter:wght@400;600&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .login-container {
            background: white;
            border-radius: 20px;
            padding: 50px 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 400px;
            width: 90%;
            text-align: center;
        }

        .logo {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2.5em;
            margin: 0 auto 20px;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }

             h1 {
            font-family: 'Playfair Display', serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-size: 2em;
            margin-bottom: 5px;
        }

        .subtitle {
            color: #888;
            font-size: 0.95em;
            margin-bottom: 30px;
        }

        .input-group {
            margin-bottom: 20px;
        }

        input[type="password"] {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1.2em;
            text-align: center;
            letter-spacing: 0.15em;
            transition: all 0.3s ease;
            font-family: 'Courier New', monospace;
        }

        input[type="password"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 8px rgba(102, 126, 234, 0.3);
        }

        #error {
            display: none;
            color: #d32f2f;
            font-size: 0.9em;
            margin-top: 15px;
            padding: 10px;
            background: #ffebee;
            border-radius: 8px;
        }

        .hint {
            color: #999;
            font-size: 0.85em;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="login-container">
      <img src="suranto.png" alt="Logo" class="logo">
        <h1>Suranto Galaxy</h1>
        <p class="subtitle">Financial Manager</p>


        <div class="input-group">
            <input 
                type="password" 
                id="passwordInput" 
                inputmode="numeric" 
                maxlength="6"
                placeholder="••••••"
                autocomplete="off"
            >
            <div id="error">❌ Sandi salah!</div>
          
    </div>

    <script>
        const passwordInput = document.getElementById('passwordInput');
        const error = document.getElementById('error');

        passwordInput.addEventListener('input', function() {
            error.style.display = 'none';

            if (this.value.length >= 3 && this.value.length <= 6) {
                checkPassword();
            }
        });

        async function checkPassword() {
            const password = passwordInput.value;

            try {
                const response = await fetch('login.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'password=' + encodeURIComponent(password)
                });

                const result = await response.json();

                if (result.success) {
                    window.location.href = 'index.php';
                } else {
                    error.style.display = 'block';
                    passwordInput.value = '';
                }
            } catch (err) {
                error.style.display = 'block';
                passwordInput.value = '';
            }
        }
    </script>
</body>
</html>