<?php
$page_title = 'Ganti Sandi';
include 'includes/header.php';

// File untuk menyimpan sandi
$password_file = 'data/page_password.txt';
if (!file_exists('data')) mkdir('data', 0777, true);

// Jika file belum ada, buat dengan sandi default
if (!file_exists($password_file)) {
    file_put_contents($password_file, '999');
}

$current_password = trim(file_get_contents($password_file));
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $old_pass = isset($_POST['old_password']) ? $_POST['old_password'] : '';
    $new_pass = isset($_POST['new_password']) ? $_POST['new_password'] : '';
    $confirm_pass = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';

    // Validasi sandi lama
    if ($old_pass !== $current_password) {
        $message = '❌ Sandi lama tidak cocok!';
        $message_type = 'error';
    }
    // Validasi sandi baru (3-6 karakter angka)
    elseif (!preg_match('/^\d{3,6}$/', $new_pass)) {
        $message = '❌ Sandi baru harus 3-6 angka!';
        $message_type = 'error';
    }
    // Validasi kecocokan sandi
    elseif ($new_pass !== $confirm_pass) {
        $message = '❌ Sandi baru tidak cocok!';
        $message_type = 'error';
    }
    // Sandi sama dengan yang lama
    elseif ($new_pass === $current_password) {
        $message = '❌ Sandi baru tidak boleh sama dengan sandi lama!';
        $message_type = 'error';
    }
    // Simpan sandi baru
    else {
        file_put_contents($password_file, $new_pass);
        $message = '✅ Sandi berhasil diubah!';
        $message_type = 'success';
        $_POST = [];
    }
}
?>

<div class="container">
    <div class="card">
        <h2>🔐 Ganti Sandi Halaman</h2>
        <p style="color:var(--text-secondary);margin-bottom:20px;">
            Ubah sandi akses utama halaman Anda
        </p>

        <?php if ($message): ?>
            <div style="padding:12px;border-radius:8px;margin-bottom:20px;<?php echo $message_type === 'success' ? 'background:#d4edda;color:#155724;' : 'background:#f8d7da;color:#721c24;'; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <form method="POST" style="display:flex;flex-direction:column;gap:15px;">
            <div>
                <label style="display:block;font-weight:600;margin-bottom:8px;">Sandi Lama</label>
                <input 
                    type="password" 
                    name="old_password" 
                    maxlength="6"
                    inputmode="numeric"
                    pattern="\d{3,6}"
                    placeholder="Masukkan sandi lama"
                    required
                    style="width:100%;padding:10px;border:1px solid var(--border-color);border-radius:8px;font-size:1em;"
                >
            </div>

            <div>
                <label style="display:block;font-weight:600;margin-bottom:8px;">Sandi Baru (3-6 angka)</label>
                <input 
                    type="password" 
                    name="new_password" 
                    maxlength="6"
                    inputmode="numeric"
                    pattern="\d{3,6}"
                    placeholder="Masukkan sandi baru"
                    required
                    style="width:100%;padding:10px;border:1px solid var(--border-color);border-radius:8px;font-size:1em;"
                >
            </div>

            <div>
                <label style="display:block;font-weight:600;margin-bottom:8px;">Konfirmasi Sandi Baru</label>
                <input 
                    type="password" 
                    name="confirm_password" 
                    maxlength="6"
                    inputmode="numeric"
                    pattern="\d{3,6}"
                    placeholder="Konfirmasi sandi baru"
                    required
                    style="width:100%;padding:10px;border:1px solid var(--border-color);border-radius:8px;font-size:1em;"
                >
            </div>

            <button type="submit" class="btn btn-success btn-full">
                <span>✓</span>
                Simpan Sandi Baru
            </button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
