function formatCurrency(amount) {
    if (amount < 1_000_000) {
        return 'Rp ' + amount.toLocaleString('id-ID');
    } else if (amount < 1_000_000_000) {
        let juta = amount / 1_000_000;
        if (juta === Math.floor(juta)) {
            return 'Rp ' + Math.floor(juta) + ' jt';
        } else {
            return 'Rp ' + juta.toFixed(1).replace('.', ',') + ' jt';
        }
    } else {
        let miliar = amount / 1_000_000_000;
        if (miliar === Math.floor(miliar)) {
            return 'Rp ' + Math.floor(miliar) + ' M';
        } else {
            return 'Rp ' + miliar.toFixed(1).replace('.', ',') + ' M';
        }
    }
}
